#include <Wire.h>
#include <LSM303AGR_ACC_Sensor.h>
////////////edge-impulse-data-forwarder --clean////
#define CONVERT_G_TO_MS2    9.80665f
#define FREQUENCY_HZ        50
#define INTERVAL_MS         (1000 / (FREQUENCY_HZ + 1))
static unsigned long last_interval_ms = 0;
// Components for the LSM303
LSM303AGR_ACC_Sensor Acc(&Wire);
void setup() {
    Serial.begin(115200);
    Serial.println("Started");

    // Initialize I2C bus.
    Wire.begin();

    // Initialize LSM303 accelerometer
    Acc.begin();
    Acc.Enable();
    Acc.EnableTemperatureSensor();

    Serial.println("LSM303 Accelerometer initialized");
}
void loop() {
    int32_t accelerometer[3];
    if (millis() > last_interval_ms + INTERVAL_MS) {
        last_interval_ms = millis();
        // Read accelerometer data
        Acc.GetAxes(accelerometer);
        // Convert to m/s^2 and print
        Serial.print(accelerometer[0] * CONVERT_G_TO_MS2 / 1000.0f); // Converting from mg to m/s^2
        Serial.print('\t');
        Serial.print(accelerometer[1] * CONVERT_G_TO_MS2 / 1000.0f); // Converting from mg to m/s^2
        Serial.print('\t');
        Serial.println(accelerometer[2] * CONVERT_G_TO_MS2 / 1000.0f); // Converting from mg to m/s^2
    }
}
